/*
 * Decompiled with CFR 0.152.
 */
package org.ros.concurrent;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CircularBlockingDeque<T>
implements Iterable<T> {
    private final T[] deque;
    private final Object mutex;
    private final int limit;
    private int start;
    private int length;

    public CircularBlockingDeque(int capacity) {
        this.deque = new Object[capacity];
        this.mutex = new Object();
        this.limit = capacity;
        this.start = 0;
        this.length = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLast(T entry) {
        Object object = this.mutex;
        synchronized (object) {
            this.deque[(this.start + this.length) % this.limit] = entry;
            if (this.length == this.limit) {
                this.start = (this.start + 1) % this.limit;
            } else {
                ++this.length;
            }
            this.mutex.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFirst(T entry) {
        Object object = this.mutex;
        synchronized (object) {
            this.start = this.start - 1 < 0 ? this.limit - 1 : --this.start;
            this.deque[this.start] = entry;
            if (this.length < this.limit) {
                ++this.length;
            }
            this.mutex.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T takeFirst() throws InterruptedException {
        T entry;
        Object object = this.mutex;
        synchronized (object) {
            while (true) {
                if (this.length > 0) {
                    entry = this.deque[this.start];
                    this.start = (this.start + 1) % this.limit;
                    --this.length;
                    break;
                }
                this.mutex.wait();
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T peekFirst() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.length > 0) {
                return this.deque[this.start];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T takeLast() throws InterruptedException {
        T entry;
        Object object = this.mutex;
        synchronized (object) {
            while (true) {
                if (this.length > 0) {
                    entry = this.deque[(this.start + this.length - 1) % this.limit];
                    --this.length;
                    break;
                }
                this.mutex.wait();
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T peekLast() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.length > 0) {
                return this.deque[(this.start + this.length - 1) % this.limit];
            }
            return null;
        }
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int offset = 0;

            @Override
            public boolean hasNext() {
                return this.offset < CircularBlockingDeque.this.length;
            }

            @Override
            public T next() {
                if (this.offset == CircularBlockingDeque.this.length) {
                    throw new NoSuchElementException();
                }
                Object entry = CircularBlockingDeque.this.deque[(CircularBlockingDeque.this.start + this.offset) % CircularBlockingDeque.this.limit];
                ++this.offset;
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

