/*
 * Decompiled with CFR 0.152.
 */
package org.ros.address;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.Callable;
import org.ros.address.InetAddressFactory;
import org.ros.address.PrivateAdvertiseAddressFactory;
import org.ros.address.PublicAdvertiseAddressFactory;
import org.ros.exception.RosRuntimeException;

public class AdvertiseAddress {
    private final String host;
    private Callable<Integer> portCallable;

    public static AdvertiseAddress newPrivate() {
        return new PrivateAdvertiseAddressFactory().newDefault();
    }

    public static AdvertiseAddress newPublic() {
        return new PublicAdvertiseAddressFactory().newDefault();
    }

    public AdvertiseAddress(String host) {
        Preconditions.checkNotNull((Object)host);
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setStaticPort(final int port) {
        this.portCallable = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return port;
            }
        };
    }

    public int getPort() {
        try {
            return this.portCallable.call();
        }
        catch (Exception e) {
            throw new RosRuntimeException(e);
        }
    }

    public void setPortCallable(Callable<Integer> portCallable) {
        this.portCallable = portCallable;
    }

    public InetAddress toInetAddress() {
        return InetAddressFactory.newFromHostString(this.host);
    }

    public InetSocketAddress toInetSocketAddress() {
        Preconditions.checkNotNull(this.portCallable);
        try {
            InetAddress address = this.toInetAddress();
            return new InetSocketAddress(address, (int)this.portCallable.call());
        }
        catch (Exception e) {
            throw new RosRuntimeException(e);
        }
    }

    public URI toUri(String scheme) {
        Preconditions.checkNotNull(this.portCallable);
        try {
            return new URI(scheme, null, this.host, this.portCallable.call(), "/", null, null);
        }
        catch (Exception e) {
            throw new RosRuntimeException("Failed to create URI: " + this, e);
        }
    }

    public boolean isLoopbackAddress() {
        return this.toInetAddress().isLoopbackAddress();
    }

    public String toString() {
        Preconditions.checkNotNull(this.portCallable);
        try {
            return "AdvertiseAddress<" + this.host + ", " + this.portCallable.call() + ">";
        }
        catch (Exception e) {
            throw new RosRuntimeException(e);
        }
    }

    public int hashCode() {
        Preconditions.checkNotNull(this.portCallable);
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        try {
            result = 31 * result + this.portCallable.call();
        }
        catch (Exception e) {
            throw new RosRuntimeException(e);
        }
        return result;
    }

    public boolean equals(Object obj) {
        Preconditions.checkNotNull(this.portCallable);
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdvertiseAddress other = (AdvertiseAddress)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        try {
            return this.portCallable.call() == other.portCallable.call();
        }
        catch (Exception e) {
            throw new RosRuntimeException(e);
        }
    }
}

