/*
 * Decompiled with CFR 0.152.
 */
package org.ros.namespace;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.ros.exception.RosRuntimeException;

public class GraphName {
    @VisibleForTesting
    static final String ANONYMOUS_PREFIX = "anonymous_";
    private static final String ROOT = "/";
    private static final String SEPARATOR = "/";
    private static final Pattern VALID_GRAPH_NAME_PATTERN = Pattern.compile("^([\\~\\/A-Za-z][\\w_\\/]*)?$");
    private static AtomicInteger anonymousCounter = new AtomicInteger();
    private final String name;

    public static GraphName newAnonymous() {
        return new GraphName(ANONYMOUS_PREFIX + anonymousCounter.incrementAndGet());
    }

    public static GraphName root() {
        return new GraphName("/");
    }

    public static GraphName empty() {
        return new GraphName("");
    }

    public static GraphName of(String name) {
        return new GraphName(GraphName.canonicalize(name));
    }

    private GraphName(String name) {
        Preconditions.checkNotNull((Object)name);
        this.name = name;
    }

    /*
     * Unable to fully structure code
     */
    private static String canonicalize(String name) {
        if (GraphName.VALID_GRAPH_NAME_PATTERN.matcher(name).matches()) ** GOTO lbl4
        throw new RosRuntimeException("Invalid graph name: " + name);
lbl-1000:
        // 1 sources

        {
            name = name.substring(0, name.length() - 1);
lbl4:
            // 2 sources

            ** while (!name.equals((Object)"/") && name.endsWith((String)"/"))
        }
lbl5:
        // 1 sources

        if (name.startsWith("~/")) {
            name = "~" + name.substring(2);
        }
        return name;
    }

    public boolean isGlobal() {
        return !this.isEmpty() && this.name.charAt(0) == '/';
    }

    public boolean isRoot() {
        return this.name.equals("/");
    }

    public boolean isEmpty() {
        return this.name.isEmpty();
    }

    public boolean isPrivate() {
        return !this.isEmpty() && this.name.charAt(0) == '~';
    }

    public boolean isRelative() {
        return !this.isPrivate() && !this.isGlobal();
    }

    public GraphName getParent() {
        if (this.name.length() == 0) {
            return GraphName.empty();
        }
        if (this.name.equals("/")) {
            return GraphName.root();
        }
        int slashIdx = this.name.lastIndexOf(47);
        if (slashIdx > 1) {
            return new GraphName(this.name.substring(0, slashIdx));
        }
        if (this.isGlobal()) {
            return GraphName.root();
        }
        return GraphName.empty();
    }

    public GraphName getBasename() {
        int slashIdx = this.name.lastIndexOf(47);
        if (slashIdx > -1) {
            if (slashIdx + 1 < this.name.length()) {
                return new GraphName(this.name.substring(slashIdx + 1));
            }
            return GraphName.empty();
        }
        return this;
    }

    public GraphName toRelative() {
        if (this.isPrivate() || this.isGlobal()) {
            return new GraphName(this.name.substring(1));
        }
        return this;
    }

    public GraphName toGlobal() {
        if (this.isGlobal()) {
            return this;
        }
        if (this.isPrivate()) {
            return new GraphName("/" + this.name.substring(1));
        }
        return new GraphName("/" + this.name);
    }

    public GraphName join(GraphName other) {
        if (other.isGlobal() || this.isEmpty()) {
            return other;
        }
        if (this.isRoot()) {
            return other.toGlobal();
        }
        if (other.isEmpty()) {
            return this;
        }
        return new GraphName(String.valueOf(this.toString()) + "/" + other.toString());
    }

    public GraphName join(String other) {
        return this.join(GraphName.of(other));
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphName other = (GraphName)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

