/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.definition;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.ros.message.MessageDefinitionProvider;
import org.ros.message.MessageIdentifier;

public class MessageDefinitionProviderChain
implements MessageDefinitionProvider {
    private final Collection<MessageDefinitionProvider> messageDefinitionProviders = Lists.newArrayList();

    public void addMessageDefinitionProvider(MessageDefinitionProvider messageDefinitionProvider) {
        this.messageDefinitionProviders.add(messageDefinitionProvider);
    }

    @Override
    public String get(String messageType) {
        for (MessageDefinitionProvider messageDefinitionProvider : this.messageDefinitionProviders) {
            if (!messageDefinitionProvider.has(messageType)) continue;
            return messageDefinitionProvider.get(messageType);
        }
        throw new NoSuchElementException("No message definition available for: " + messageType);
    }

    @Override
    public boolean has(String messageType) {
        for (MessageDefinitionProvider messageDefinitionProvider : this.messageDefinitionProviders) {
            if (!messageDefinitionProvider.has(messageType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getPackages() {
        HashSet result = Sets.newHashSet();
        for (MessageDefinitionProvider messageDefinitionProvider : this.messageDefinitionProviders) {
            Collection<String> packages = messageDefinitionProvider.getPackages();
            result.addAll(packages);
        }
        return result;
    }

    @Override
    public Collection<MessageIdentifier> getMessageIdentifiersByPackage(String pkg) {
        HashSet result = Sets.newHashSet();
        for (MessageDefinitionProvider messageDefinitionProvider : this.messageDefinitionProviders) {
            Collection<MessageIdentifier> messageIdentifiers = messageDefinitionProvider.getMessageIdentifiersByPackage(pkg);
            if (messageIdentifiers == null) continue;
            result.addAll(messageIdentifiers);
        }
        return result;
    }
}

