/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.provider;

import java.text.DecimalFormat;
import org.eclipse.apogy.core.environment.Star;
import org.eclipse.apogy.core.environment.provider.StarItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class StarCustomItemProvider
extends StarItemProvider {
    public static final String DEGREE_STRING = "\u00b0";
    private final DecimalFormat rightAscensionFormat = new DecimalFormat("0.00");
    private final DecimalFormat declinationFormat = new DecimalFormat("0.00");
    private final DecimalFormat magnitudeFormat = new DecimalFormat("0.00");

    public StarCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        Star star = (Star)object;
        String label = "";
        if (star.getEquatorialCoordinates() != null) {
            label = String.valueOf(label) + "r.a. " + this.rightAscensionFormat.format(Math.toDegrees(star.getEquatorialCoordinates().getRightAscension())) + DEGREE_STRING;
            label = String.valueOf(label) + ", dec. " + this.declinationFormat.format(Math.toDegrees(star.getEquatorialCoordinates().getDeclination())) + DEGREE_STRING;
        }
        return (label = String.valueOf(label) + ", mag. " + this.magnitudeFormat.format(star.getMagnitude())) == null || label.length() == 0 ? this.getString("_UI_Star_type") : String.valueOf(this.getString("_UI_Star_type")) + " " + label;
    }
}

