/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.provider;

import java.text.DecimalFormat;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.provider.Matrix3x3ItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class Matrix3x3CustomItemProvider
extends Matrix3x3ItemProvider {
    public static final String DEGREE_STRING = "\u00b0";
    private final DecimalFormat orientationFormat = new DecimalFormat("0.0");

    public Matrix3x3CustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        Matrix3x3 matrix3x3 = (Matrix3x3)object;
        Matrix3d rotation = new Matrix3d(matrix3x3.asMatrix3d());
        Vector3d rotationVector = GeometricUtils.extractRotationFromXYZRotMatrix((Matrix3d)rotation);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getString("_UI_Matrix3x3_type"));
        buffer.append(" (" + this.orientationFormat.format(Math.toDegrees(rotationVector.getX())) + DEGREE_STRING + ", ");
        buffer.append(String.valueOf(this.orientationFormat.format(Math.toDegrees(rotationVector.getY()))) + DEGREE_STRING + ", ");
        buffer.append(String.valueOf(this.orientationFormat.format(Math.toDegrees(rotationVector.getZ()))) + DEGREE_STRING + ")");
        return buffer.toString();
    }
}

