/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class RelativeLayout
implements LayoutManager {
    private double[] relativeSizes;
    public static final int HORIZONTAL_LAYOUT = 0;
    public static final int VERTICAL_LAYOUT = 1;
    private int type = 0;

    public RelativeLayout(double[] relativeSizes) {
        this(relativeSizes, 0);
    }

    public RelativeLayout(double[] relativeSizes, int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("RelativeLayout: invalid type:" + type);
        }
        this.relativeSizes = relativeSizes;
        this.type = type;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        Dimension size = parent.getSize();
        Component[] comps = parent.getComponents();
        int[] absoluteSizes = new int[comps.length];
        int i = 0;
        while (i < absoluteSizes.length) {
            switch (this.type) {
                case 0: {
                    absoluteSizes[i] = (int)Math.round((double)size.width * this.relativeSizes[i]);
                    break;
                }
                case 1: {
                    absoluteSizes[i] = (int)Math.round((double)size.height * this.relativeSizes[i]);
                    break;
                }
                default: {
                    throw new IllegalStateException("RelativeLayout: type invalid during layout: " + this.type);
                }
            }
            ++i;
        }
        int last = 0;
        int i2 = 0;
        while (i2 < absoluteSizes.length) {
            Component c = comps[i2];
            switch (this.type) {
                case 0: {
                    c.setBounds(last, 0, absoluteSizes[i2], size.height);
                    break;
                }
                case 1: {
                    c.setBounds(0, last, size.width, absoluteSizes[i2]);
                    break;
                }
                default: {
                    throw new IllegalStateException("RelativeLayout: type invalid during layout: " + this.type);
                }
            }
            last += absoluteSizes[i2];
            ++i2;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        int w = 0;
        int h = 0;
        Component[] comps = parent.getComponents();
        int i = 0;
        while (i < comps.length) {
            Dimension pref = comps[i].getPreferredSize();
            switch (this.type) {
                case 0: {
                    w += pref.width;
                    if (pref.height <= h) break;
                    h = pref.height;
                    break;
                }
                case 1: {
                    h += pref.height;
                    if (pref.width <= w) break;
                    w = pref.width;
                    break;
                }
                default: {
                    throw new IllegalStateException("RelativeLayout: type invalid during preferredSize calculation: " + this.type);
                }
            }
            ++i;
        }
        return new Dimension(w, h);
    }

    public void removeLayoutComponent(Component comp) {
    }
}

