/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.awt.FlowLabel;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class QueryDialog
extends Dialog
implements ActionListener,
Runnable {
    private Object target = null;
    private Vector buttonVector = null;
    private String[] methods = null;
    private Object selectedButton = null;
    private Object selectedButtonLock = new Object();

    public QueryDialog(Object target, Frame parent, String title, String message, String[] buttons, String[] methods) {
        super(parent, title, true);
        int width = 300;
        int height = 200;
        this.target = target;
        this.methods = methods;
        this.createDialog(message, buttons);
        ((Component)this).setSize(width, height);
        Point parentLocation = parent.getLocationOnScreen();
        Dimension parentSize = parent.getSize();
        int x = parentLocation.x + (parentSize.width - width) / 2;
        int y = parentLocation.y + (parentSize.height - height) / 2;
        ((Component)this).setLocation(x, y);
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object button = e.getSource();
        this.setSelectedButton(button);
        if (this.buttonVector.contains(button)) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public Object callObjectMethod(Object target, String methodName, Class[] argTypes, Object[] args) {
        try {
            Class<?> targetClass = target.getClass();
            Method method = targetClass.getMethod(methodName, argTypes);
            return method.invoke(target, args);
        }
        catch (NoSuchMethodException e) {
            System.out.println("Method " + methodName + " is not declared in class " + target.getClass().getName());
            e.printStackTrace();
        }
        catch (SecurityException e) {
            System.out.println("No access for method " + methodName + " in class " + target.getClass().getName());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.out.println("No access for method " + methodName + " in class " + target.getClass().getName());
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.out.println("Bad argument passed to method " + methodName + " in class " + target.getClass().getName());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            System.out.println("InvocationTargetException thrown in method " + methodName + " in class " + target.getClass().getName());
            e.getTargetException().printStackTrace();
        }
        catch (NullPointerException e) {
            System.out.println("Null object passed to callObjectMethod.");
            e.printStackTrace();
        }
        return null;
    }

    private void createDialog(String message, String[] buttons) {
        this.add((Component)new FlowLabel(message), "Center");
        Panel buttonPanel = new Panel(new FlowLayout());
        this.buttonVector = new Vector();
        int index = 0;
        while (index < buttons.length) {
            Button button = new Button(buttons[index]);
            buttonPanel.add(button);
            button.addActionListener(this);
            this.buttonVector.addElement(button);
            ++index;
        }
        this.add((Component)buttonPanel, "South");
    }

    private Object getSelectedButton() {
        Object object = this.selectedButtonLock;
        synchronized (object) {
            Object object2 = this.selectedButton;
            Object var3_3 = null;
            return object2;
        }
    }

    public void run() {
        String methodName;
        Object button = this.getSelectedButton();
        int selectedButton = this.buttonVector.indexOf(button);
        if (this.target != null && this.methods != null && this.methods.length > selectedButton && (methodName = this.methods[selectedButton]) != null) {
            this.callObjectMethod(this.target, methodName, null, null);
        }
    }

    private void setSelectedButton(Object button) {
        Object object = this.selectedButtonLock;
        synchronized (object) {
            this.selectedButton = button;
        }
    }
}

