/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.util;

import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.ComponentDescriptionLookup;
import com.sun.prodreg.core.ComponentReference;
import com.sun.prodreg.core.ComponentType;
import com.sun.prodreg.util.Localizer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class Utils
implements Serializable {
    public static Vector alphaCache(Vector childCache) {
        Vector<String> unorderedLeafs = new Vector<String>();
        Vector<String> unorderedNodes = new Vector<String>();
        Vector ordered = new Vector();
        Hashtable<String, ComponentDescription> lookup = new Hashtable<String, ComponentDescription>();
        int i = 0;
        while (i < childCache.size()) {
            ComponentDescription kid = (ComponentDescription)childCache.elementAt(i);
            String dname = Utils.getDisplayName(kid);
            ComponentReference[] kids = kid.getChildren();
            if (kids != null && kids.length > 0) {
                unorderedNodes.addElement(dname);
            } else {
                unorderedLeafs.addElement(dname);
            }
            lookup.put(dname, kid);
            ++i;
        }
        Vector alphaNodes = Utils.alphabetize(unorderedNodes);
        Vector alphaLeafs = Utils.alphabetize(unorderedLeafs);
        int i2 = 0;
        while (i2 < alphaNodes.size()) {
            ordered.addElement(lookup.get((String)alphaNodes.elementAt(i2)));
            ++i2;
        }
        int i3 = 0;
        while (i3 < alphaLeafs.size()) {
            ordered.addElement(lookup.get((String)alphaLeafs.elementAt(i3)));
            ++i3;
        }
        return ordered;
    }

    public static Vector alphabetize(Vector unordered) {
        Vector<String> ordered = new Vector<String>();
        int size = unordered.size();
        int i = 0;
        while (i < size) {
            String candidate = (String)unordered.elementAt(i);
            int osize = ordered.size();
            boolean inserted = false;
            int j = 0;
            while (j < osize) {
                String pos = (String)ordered.elementAt(j);
                if (candidate.compareTo(pos) <= 0) {
                    ordered.insertElementAt(candidate, j);
                    inserted = true;
                    break;
                }
                ++j;
            }
            if (!inserted) {
                ordered.addElement(candidate);
            }
            ++i;
        }
        return ordered;
    }

    public static Vector getDescriptionStrings(ComponentDescription desc) {
        Hashtable appData;
        String[] compat_vers;
        Vector dept;
        Vector reqd;
        String unin;
        ComponentType type;
        String[] langs;
        if (desc == null) {
            return new Vector();
        }
        Vector<String> result = new Vector<String>();
        String nm = desc.getUniqueName();
        if (nm != null) {
            result.addElement(Localizer.resolve("<L ProdRegResources.UniqueName>: " + nm));
        }
        if ((langs = desc.getDisplayLanguages()) != null) {
            String supp = Localizer.resolve("<L ProdRegResources.SupportedLangs>: ");
            result.addElement(supp);
            int i = 0;
            while (i < langs.length) {
                result.addElement("   " + langs[i]);
                ++i;
            }
        }
        if ((type = desc.getComponentType()) != null) {
            String typeString = "";
            typeString = type.equals(ComponentType.product) ? Localizer.resolve("<L ProdRegResources.Product>") : (type.equals(ComponentType.feature) ? Localizer.resolve("<L ProdRegResources.Feature>") : (type.equals(ComponentType.component) ? Localizer.resolve("<L ProdRegResources.Component>") : Localizer.resolve("<L ProdRegResources.Unknown>")));
            result.addElement(Localizer.resolve("<L ProdRegResources.CompType>: " + typeString));
        }
        if ((unin = desc.getUninstaller()) != null) {
            result.addElement(Localizer.resolve("<L ProdRegResources.Uninstaller>: " + unin));
        }
        if ((reqd = desc.getRequiredComponents()) != null) {
            result.addElement(Localizer.resolve("<L ProdRegResources.Required>"));
            int i = 0;
            while (i < reqd.size()) {
                ComponentReference ref = (ComponentReference)reqd.elementAt(i);
                String id = ref.getID();
                ComponentDescription ref_reqd = ComponentDescriptionLookup.get(id);
                if (ref_reqd != null) {
                    result.addElement("    " + Utils.getDisplayName(ref_reqd));
                } else {
                    String missing = Localizer.resolve("<L ProdRegResources.MissingReq>");
                    result.addElement(String.valueOf(missing) + ": " + id);
                }
                ++i;
            }
        }
        if ((dept = desc.getDependentComponents()) != null) {
            result.addElement(Localizer.resolve("<L ProdRegResources.Dependent>"));
            int i = 0;
            while (i < dept.size()) {
                ComponentReference ref = (ComponentReference)dept.elementAt(i);
                String id = ref.getID();
                ComponentDescription ref_dept = ComponentDescriptionLookup.get(id);
                if (ref_dept != null) {
                    result.addElement("    " + Utils.getDisplayName(ref_dept));
                } else {
                    String missing = Localizer.resolve("<L ProdRegResources.MissingDep>");
                    result.addElement(String.valueOf(missing) + ": " + id);
                }
                ++i;
            }
        }
        if ((compat_vers = desc.getCompatibleVersions()) != null) {
            String compat_ver = Localizer.resolve("<L ProdRegResources.CompatVersions>: ");
            if (compat_vers != null) {
                int i = 0;
                while (i < compat_vers.length) {
                    compat_ver = String.valueOf(compat_ver) + compat_vers[i];
                    if (i != langs.length - 1) {
                        compat_ver = String.valueOf(compat_ver) + ", ";
                    }
                    ++i;
                }
            }
            result.addElement(compat_ver);
        }
        if ((appData = desc.getData()) != null) {
            Vector unordered = new Vector();
            Enumeration keys = appData.keys();
            while (keys.hasMoreElements()) {
                unordered.addElement(keys.nextElement());
            }
            Vector alphaAppData = Utils.alphabetize(unordered);
            int i = 0;
            while (i < alphaAppData.size()) {
                String key = (String)alphaAppData.elementAt(i);
                String val = (String)appData.get(key);
                result.addElement(String.valueOf(key) + ": " + val);
                ++i;
            }
        }
        return result;
    }

    public static String getDisplayName(ComponentDescription desc) {
        String nm = desc.getDisplayName(Utils.getLocaleName());
        if (nm == null) {
            nm = desc.getDisplayName("en");
        }
        if (nm == null) {
            nm = desc.getUniqueName();
        }
        nm = Utils.trunc(nm, 50);
        return nm.trim();
    }

    public static String getLocaleName() {
        return Localizer.localeName(Locale.getDefault());
    }

    public static boolean hashtablesEqual(Hashtable h1, Hashtable h2) {
        if (h1 == h2) {
            return true;
        }
        if (h1 == null || h2 == null) {
            return false;
        }
        if (h1.size() != h2.size()) {
            return false;
        }
        Enumeration e = h1.keys();
        while (e.hasMoreElements()) {
            Object testValue;
            Object key = e.nextElement();
            Object value = h1.get(key);
            if (value.equals(testValue = h2.get(key))) continue;
            return false;
        }
        return true;
    }

    public static String listPackages(ComponentDescription desc) {
        ComponentReference[] kids;
        String pkgList = desc.getData("pkgs");
        String finalList = "";
        if (pkgList != null) {
            StringTokenizer p = new StringTokenizer(pkgList);
            while (p.hasMoreTokens()) {
                String pkg = p.nextToken();
                finalList = String.valueOf(finalList) + pkg + ' ';
            }
        }
        if ((kids = desc.getChildren()) != null) {
            int i = 0;
            while (i < kids.length) {
                String kidList;
                ComponentDescription kid = ComponentDescriptionLookup.get(kids[i].getID());
                if (kid != null && (kidList = Utils.listPackages(kid)) != null) {
                    finalList = String.valueOf(finalList) + kidList + ' ';
                }
                ++i;
            }
        }
        if (finalList.trim().equals("")) {
            return null;
        }
        return finalList.trim();
    }

    public static boolean objectsEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!o1.getClass().equals(o2.getClass())) {
            return false;
        }
        if (!o1.getClass().isArray()) {
            return o1.equals(o2);
        }
        Object[] array1 = (Object[])o1;
        Object[] array2 = (Object[])o2;
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (!Utils.objectsEqual(array1[i], array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String trunc(String longName, int length) {
        String result = longName;
        if (result != null && result.length() > length) {
            result = String.valueOf(result.substring(0, length)) + "...";
        }
        return result;
    }

    public static boolean vectorsEqual(Vector v1, Vector v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (v1.size() != v2.size()) {
            return false;
        }
        Enumeration e = v1.elements();
        while (e.hasMoreElements()) {
            Object value = e.nextElement();
            if (v2.contains(value)) continue;
            return false;
        }
        return true;
    }
}

