/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;

public class TitleBox
extends Panel {
    private Insets insets = new Insets(7, 7, 7, 7);
    public static final Insets MINIMUM_INSETS = new Insets(10, 10, 10, 10);
    private String title = null;

    public TitleBox() {
        this.setLayout(new GridBagLayout());
    }

    public TitleBox(String title) {
        this();
        this.title = title;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public String getTitle() {
        return this.title;
    }

    public void paint(Graphics g) {
        super.paint(g);
        Dimension size = this.getSize();
        Color background = this.getBackground();
        Color foreground = this.getForeground();
        Color lightLine = background.brighter().brighter();
        Color darkLine = background.darker();
        Font current = this.getFont();
        FontMetrics fm = null;
        if (current != null) {
            fm = this.getFontMetrics(current);
        }
        int maxheight = 15;
        if (fm != null) {
            maxheight = fm.getMaxAscent() + fm.getMaxDescent();
        }
        g.setColor(lightLine);
        g.drawRect(this.insets.left + 1, maxheight / 2 + 1, size.width - this.insets.left - this.insets.right, size.height - this.insets.bottom - maxheight / 2);
        g.setColor(darkLine);
        g.drawRect(this.insets.left, maxheight / 2, size.width - this.insets.left - this.insets.right, size.height - this.insets.bottom - maxheight / 2);
        if (this.title != null) {
            g.clearRect(this.insets.left + fm.stringWidth("-"), maxheight / 2, fm.stringWidth(this.title) + 4, 2);
            g.setColor(lightLine);
            g.drawString(this.title, this.insets.left + fm.stringWidth("-") + 2 + 1, maxheight / 2 + fm.getHeight() / 2 - 1 + 1);
            g.setColor(foreground.brighter());
            g.drawString(this.title, this.insets.left + fm.stringWidth("-") + 2, maxheight / 2 + fm.getHeight() / 2 - 1);
        }
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

