#!/bin/sh

# panic: ktrace_enter: flag set
# cpuid = 0
# time = 1621577415
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe01c0025670
# vpanic() at vpanic+0x181/frame 0xfffffe01c00256c0
# panic() at panic+0x43/frame 0xfffffe01c0025720
# ktrnamei() at ktrnamei+0xdb/frame 0xfffffe01c0025750
# namei() at namei+0x805/frame 0xfffffe01c0025800
# vn_open_cred() at vn_open_cred+0x497/frame 0xfffffe01c0025970
# sys_ktrace() at sys_ktrace+0x1a0/frame 0xfffffe01c0025ac0
# amd64_syscall() at amd64_syscall+0x147/frame 0xfffffe01c0025bf0
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe01c0025bf0
# --- syscall (0, FreeBSD ELF64, nosys), rip = 0x8003b054a, rsp = 0x7fffdfffdf68, rbp = 0x7fffdfffdf90 ---
# KDB: enter: panic
# [ thread pid 80729 tid 101297 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x1281d9e(%rip)
# db> x/s version
# version: FreeBSD 14.0-CURRENT #0 main-n246739-fc0dc94029d-dirty: Wed May 19 05:54:45 CEST 2021
# pho@t2.osted.lan:/usr/src/sys/amd64/compile/PHO
# db>

[ `uname -p` != "amd64" ] && exit 0
[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
cat > /tmp/syzkaller39.c <<EOF
// https://syzkaller.appspot.com/bug?id=01d7251d81bbf2bf91279ecc73897961cd72beea
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+d0a4de45e58d3c08af4b@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <time.h>
#include <unistd.h>

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void loop(void)
{
  int i, call, thread;
  int collide = 0;
again:
  for (call = 0; call < 3; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      if (collide && (call % 2) == 0)
        break;
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
  if (!collide) {
    collide = 1;
    goto again;
  }
}

uint64_t r[1] = {0x0};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    memcpy((void*)0x20000140, "./file0\000", 8);
    syscall(SYS_open, 0x20000140ul, 0x200ul, 0ul);
    break;
  case 1:
    res = syscall(SYS_getpid);
    if (res != -1)
      r[0] = res;
    break;
  case 2:
    memcpy((void*)0x20000040, "./file0\000", 8);
    syscall(SYS_ktrace, 0x20000040ul, 0ul, 0x4722db8820f38dbbul, r[0]);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller39 -Wall -Wextra -O0 /tmp/syzkaller39.c -lpthread ||
    exit 1

(cd /tmp; timeout 3m ./syzkaller39)

rm -rf /tmp/syzkaller39 /tmp/syzkaller39.c /tmp/syzkaller.*
exit 0
